<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ShoppingContent;

class ProductsListResponse extends \Google\Collection
{
  protected $collection_key = 'resources';
  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "`content#productsListResponse`".
   *
   * @var string
   */
  public $kind;
  /**
   * The token for the retrieval of the next page of products.
   *
   * @var string
   */
  public $nextPageToken;
  protected $resourcesType = Product::class;
  protected $resourcesDataType = 'array';

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "`content#productsListResponse`".
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * The token for the retrieval of the next page of products.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * @param Product[] $resources
   */
  public function setResources($resources)
  {
    $this->resources = $resources;
  }
  /**
   * @return Product[]
   */
  public function getResources()
  {
    return $this->resources;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ProductsListResponse::class, 'Google_Service_ShoppingContent_ProductsListResponse');
