<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceUsage;

class DisableServiceRequest extends \Google\Model
{
  /**
   * When unset, the default behavior is used, which is SKIP.
   */
  public const CHECK_IF_SERVICE_HAS_USAGE_CHECK_IF_SERVICE_HAS_USAGE_UNSPECIFIED = 'CHECK_IF_SERVICE_HAS_USAGE_UNSPECIFIED';
  /**
   * If set, skip checking service usage when disabling a service.
   */
  public const CHECK_IF_SERVICE_HAS_USAGE_SKIP = 'SKIP';
  /**
   * If set, service usage is checked when disabling the service. If a service,
   * or its dependents, has usage in the last 30 days, the request returns a
   * FAILED_PRECONDITION error.
   */
  public const CHECK_IF_SERVICE_HAS_USAGE_CHECK = 'CHECK';
  /**
   * Defines the behavior for checking service usage when disabling a service.
   *
   * @var string
   */
  public $checkIfServiceHasUsage;
  /**
   * Indicates if services that are enabled and which depend on this service
   * should also be disabled. If not set, an error will be generated if any
   * enabled services depend on the service to be disabled. When set, the
   * service, and any enabled services that depend on it, will be disabled
   * together.
   *
   * @var bool
   */
  public $disableDependentServices;

  /**
   * Defines the behavior for checking service usage when disabling a service.
   *
   * Accepted values: CHECK_IF_SERVICE_HAS_USAGE_UNSPECIFIED, SKIP, CHECK
   *
   * @param self::CHECK_IF_SERVICE_HAS_USAGE_* $checkIfServiceHasUsage
   */
  public function setCheckIfServiceHasUsage($checkIfServiceHasUsage)
  {
    $this->checkIfServiceHasUsage = $checkIfServiceHasUsage;
  }
  /**
   * @return self::CHECK_IF_SERVICE_HAS_USAGE_*
   */
  public function getCheckIfServiceHasUsage()
  {
    return $this->checkIfServiceHasUsage;
  }
  /**
   * Indicates if services that are enabled and which depend on this service
   * should also be disabled. If not set, an error will be generated if any
   * enabled services depend on the service to be disabled. When set, the
   * service, and any enabled services that depend on it, will be disabled
   * together.
   *
   * @param bool $disableDependentServices
   */
  public function setDisableDependentServices($disableDependentServices)
  {
    $this->disableDependentServices = $disableDependentServices;
  }
  /**
   * @return bool
   */
  public function getDisableDependentServices()
  {
    return $this->disableDependentServices;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DisableServiceRequest::class, 'Google_Service_ServiceUsage_DisableServiceRequest');
