<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Script;

class CreateProjectRequest extends \Google\Model
{
  /**
   * The Drive ID of a parent file that the created script project is bound to.
   * This is usually the ID of a Google Doc, Google Sheet, Google Form, or
   * Google Slides file. If not set, a standalone script project is created.
   *
   * @var string
   */
  public $parentId;
  /**
   * The title for the project.
   *
   * @var string
   */
  public $title;

  /**
   * The Drive ID of a parent file that the created script project is bound to.
   * This is usually the ID of a Google Doc, Google Sheet, Google Form, or
   * Google Slides file. If not set, a standalone script project is created.
   *
   * @param string $parentId
   */
  public function setParentId($parentId)
  {
    $this->parentId = $parentId;
  }
  /**
   * @return string
   */
  public function getParentId()
  {
    return $this->parentId;
  }
  /**
   * The title for the project.
   *
   * @param string $title
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CreateProjectRequest::class, 'Google_Service_Script_CreateProjectRequest');
