<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SaaSServiceManagement;

class Upgrade extends \Google\Collection
{
  protected $collection_key = 'inputVariables';
  protected $inputVariablesType = UnitVariable::class;
  protected $inputVariablesDataType = 'array';
  /**
   * Optional. Reference to the Release object to use for the Unit. (optional).
   *
   * @var string
   */
  public $release;

  /**
   * Optional. Set of input variables. Maximum 100. (optional)
   *
   * @param UnitVariable[] $inputVariables
   */
  public function setInputVariables($inputVariables)
  {
    $this->inputVariables = $inputVariables;
  }
  /**
   * @return UnitVariable[]
   */
  public function getInputVariables()
  {
    return $this->inputVariables;
  }
  /**
   * Optional. Reference to the Release object to use for the Unit. (optional).
   *
   * @param string $release
   */
  public function setRelease($release)
  {
    $this->release = $release;
  }
  /**
   * @return string
   */
  public function getRelease()
  {
    return $this->release;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Upgrade::class, 'Google_Service_SaaSServiceManagement_Upgrade');
