<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SaaSServiceManagement;

class RolloutKind extends \Google\Model
{
  /**
   * Strategy unspecified.
   */
  public const UPDATE_UNIT_KIND_STRATEGY_UPDATE_UNIT_KIND_STRATEGY_UNSPECIFIED = 'UPDATE_UNIT_KIND_STRATEGY_UNSPECIFIED';
  /**
   * Update the unit kind strategy on the rollout start.
   */
  public const UPDATE_UNIT_KIND_STRATEGY_UPDATE_UNIT_KIND_STRATEGY_ON_START = 'UPDATE_UNIT_KIND_STRATEGY_ON_START';
  /**
   * Never update the unit kind.
   */
  public const UPDATE_UNIT_KIND_STRATEGY_UPDATE_UNIT_KIND_STRATEGY_NEVER = 'UPDATE_UNIT_KIND_STRATEGY_NEVER';
  /**
   * Optional. Annotations is an unstructured key-value map stored with a
   * resource that may be set by external tools to store and retrieve arbitrary
   * metadata. They are not queryable and should be preserved when modifying
   * objects. More info: https://kubernetes.io/docs/user-guide/annotations
   *
   * @var string[]
   */
  public $annotations;
  /**
   * Output only. The timestamp when the resource was created.
   *
   * @var string
   */
  public $createTime;
  protected $errorBudgetType = ErrorBudget::class;
  protected $errorBudgetDataType = '';
  /**
   * Output only. An opaque value that uniquely identifies a version or
   * generation of a resource. It can be used to confirm that the client and
   * server agree on the ordering of a resource being written.
   *
   * @var string
   */
  public $etag;
  /**
   * Optional. The labels on the resource, which can be used for categorization.
   * similar to Kubernetes resource labels.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Identifier. The resource name (full URI of the resource) following the
   * standard naming scheme:
   * "projects/{project}/locations/{location}/rolloutKinds/{rollout_kind_id}"
   *
   * @var string
   */
  public $name;
  /**
   * Optional. The strategy used for executing a Rollout. This is a required
   * field. There are two supported values strategies which are used to control
   * - "Google.Cloud.Simple.AllAtOnce" -
   * "Google.Cloud.Simple.OneLocationAtATime" A rollout with one of these simple
   * strategies will rollout across all locations defined in the associated
   * UnitKind's Saas Locations.
   *
   * @var string
   */
  public $rolloutOrchestrationStrategy;
  /**
   * Output only. The unique identifier of the resource. UID is unique in the
   * time and space for this resource within the scope of the service. It is
   * typically generated by the server on successful creation of a resource and
   * must not be changed. UID is used to uniquely identify resources with
   * resource name reuses. This should be a UUID4.
   *
   * @var string
   */
  public $uid;
  /**
   * Optional. CEL(https://github.com/google/cel-spec) formatted filter string
   * against Unit. The filter will be applied to determine the eligible unit
   * population. This filter can only reduce, but not expand the scope of the
   * rollout.
   *
   * @var string
   */
  public $unitFilter;
  /**
   * Required. Immutable. UnitKind that this rollout kind corresponds to.
   * Rollouts stemming from this rollout kind will target the units of this unit
   * kind. In other words, this defines the population of target units to be
   * upgraded by rollouts.
   *
   * @var string
   */
  public $unitKind;
  /**
   * Output only. The timestamp when the resource was last updated. Any change
   * to the resource made by users must refresh this value. Changes to a
   * resource made by the service should refresh this value.
   *
   * @var string
   */
  public $updateTime;
  /**
   * Optional. The config for updating the unit kind. By default, the unit kind
   * will be updated on the rollout start.
   *
   * @var string
   */
  public $updateUnitKindStrategy;

  /**
   * Optional. Annotations is an unstructured key-value map stored with a
   * resource that may be set by external tools to store and retrieve arbitrary
   * metadata. They are not queryable and should be preserved when modifying
   * objects. More info: https://kubernetes.io/docs/user-guide/annotations
   *
   * @param string[] $annotations
   */
  public function setAnnotations($annotations)
  {
    $this->annotations = $annotations;
  }
  /**
   * @return string[]
   */
  public function getAnnotations()
  {
    return $this->annotations;
  }
  /**
   * Output only. The timestamp when the resource was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Optional. The configuration for error budget. If the number of failed units
   * exceeds max(allowed_count, allowed_ratio * total_units), the rollout will
   * be paused. If not set, all units will be attempted to be updated regardless
   * of the number of failures encountered.
   *
   * @param ErrorBudget $errorBudget
   */
  public function setErrorBudget(ErrorBudget $errorBudget)
  {
    $this->errorBudget = $errorBudget;
  }
  /**
   * @return ErrorBudget
   */
  public function getErrorBudget()
  {
    return $this->errorBudget;
  }
  /**
   * Output only. An opaque value that uniquely identifies a version or
   * generation of a resource. It can be used to confirm that the client and
   * server agree on the ordering of a resource being written.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * Optional. The labels on the resource, which can be used for categorization.
   * similar to Kubernetes resource labels.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Identifier. The resource name (full URI of the resource) following the
   * standard naming scheme:
   * "projects/{project}/locations/{location}/rolloutKinds/{rollout_kind_id}"
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Optional. The strategy used for executing a Rollout. This is a required
   * field. There are two supported values strategies which are used to control
   * - "Google.Cloud.Simple.AllAtOnce" -
   * "Google.Cloud.Simple.OneLocationAtATime" A rollout with one of these simple
   * strategies will rollout across all locations defined in the associated
   * UnitKind's Saas Locations.
   *
   * @param string $rolloutOrchestrationStrategy
   */
  public function setRolloutOrchestrationStrategy($rolloutOrchestrationStrategy)
  {
    $this->rolloutOrchestrationStrategy = $rolloutOrchestrationStrategy;
  }
  /**
   * @return string
   */
  public function getRolloutOrchestrationStrategy()
  {
    return $this->rolloutOrchestrationStrategy;
  }
  /**
   * Output only. The unique identifier of the resource. UID is unique in the
   * time and space for this resource within the scope of the service. It is
   * typically generated by the server on successful creation of a resource and
   * must not be changed. UID is used to uniquely identify resources with
   * resource name reuses. This should be a UUID4.
   *
   * @param string $uid
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
  /**
   * Optional. CEL(https://github.com/google/cel-spec) formatted filter string
   * against Unit. The filter will be applied to determine the eligible unit
   * population. This filter can only reduce, but not expand the scope of the
   * rollout.
   *
   * @param string $unitFilter
   */
  public function setUnitFilter($unitFilter)
  {
    $this->unitFilter = $unitFilter;
  }
  /**
   * @return string
   */
  public function getUnitFilter()
  {
    return $this->unitFilter;
  }
  /**
   * Required. Immutable. UnitKind that this rollout kind corresponds to.
   * Rollouts stemming from this rollout kind will target the units of this unit
   * kind. In other words, this defines the population of target units to be
   * upgraded by rollouts.
   *
   * @param string $unitKind
   */
  public function setUnitKind($unitKind)
  {
    $this->unitKind = $unitKind;
  }
  /**
   * @return string
   */
  public function getUnitKind()
  {
    return $this->unitKind;
  }
  /**
   * Output only. The timestamp when the resource was last updated. Any change
   * to the resource made by users must refresh this value. Changes to a
   * resource made by the service should refresh this value.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
  /**
   * Optional. The config for updating the unit kind. By default, the unit kind
   * will be updated on the rollout start.
   *
   * Accepted values: UPDATE_UNIT_KIND_STRATEGY_UNSPECIFIED,
   * UPDATE_UNIT_KIND_STRATEGY_ON_START, UPDATE_UNIT_KIND_STRATEGY_NEVER
   *
   * @param self::UPDATE_UNIT_KIND_STRATEGY_* $updateUnitKindStrategy
   */
  public function setUpdateUnitKindStrategy($updateUnitKindStrategy)
  {
    $this->updateUnitKindStrategy = $updateUnitKindStrategy;
  }
  /**
   * @return self::UPDATE_UNIT_KIND_STRATEGY_*
   */
  public function getUpdateUnitKindStrategy()
  {
    return $this->updateUnitKindStrategy;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RolloutKind::class, 'Google_Service_SaaSServiceManagement_RolloutKind');
