<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring;

class LogMatch extends \Google\Model
{
  /**
   * Required. A logs-based filter. See Advanced Logs Queries
   * (https://cloud.google.com/logging/docs/view/advanced-queries) for how this
   * filter should be constructed.
   *
   * @var string
   */
  public $filter;
  /**
   * Optional. A map from a label key to an extractor expression, which is used
   * to extract the value for this label key. Each entry in this map is a
   * specification for how data should be extracted from log entries that match
   * filter. Each combination of extracted values is treated as a separate rule
   * for the purposes of triggering notifications. Label keys and corresponding
   * values can be used in notifications generated by this condition.Please see
   * the documentation on logs-based metric valueExtractors (https://cloud.googl
   * e.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.v
   * alue_extractor) for syntax and examples.
   *
   * @var string[]
   */
  public $labelExtractors;

  /**
   * Required. A logs-based filter. See Advanced Logs Queries
   * (https://cloud.google.com/logging/docs/view/advanced-queries) for how this
   * filter should be constructed.
   *
   * @param string $filter
   */
  public function setFilter($filter)
  {
    $this->filter = $filter;
  }
  /**
   * @return string
   */
  public function getFilter()
  {
    return $this->filter;
  }
  /**
   * Optional. A map from a label key to an extractor expression, which is used
   * to extract the value for this label key. Each entry in this map is a
   * specification for how data should be extracted from log entries that match
   * filter. Each combination of extracted values is treated as a separate rule
   * for the purposes of triggering notifications. Label keys and corresponding
   * values can be used in notifications generated by this condition.Please see
   * the documentation on logs-based metric valueExtractors (https://cloud.googl
   * e.com/logging/docs/reference/v2/rest/v2/projects.metrics#LogMetric.FIELDS.v
   * alue_extractor) for syntax and examples.
   *
   * @param string[] $labelExtractors
   */
  public function setLabelExtractors($labelExtractors)
  {
    $this->labelExtractors = $labelExtractors;
  }
  /**
   * @return string[]
   */
  public function getLabelExtractors()
  {
    return $this->labelExtractors;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LogMatch::class, 'Google_Service_Monitoring_LogMatch');
