<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class InputMetrics extends \Google\Model
{
  /**
   * @var string
   */
  public $bytesRead;
  /**
   * @var string
   */
  public $recordsRead;

  /**
   * @param string $bytesRead
   */
  public function setBytesRead($bytesRead)
  {
    $this->bytesRead = $bytesRead;
  }
  /**
   * @return string
   */
  public function getBytesRead()
  {
    return $this->bytesRead;
  }
  /**
   * @param string $recordsRead
   */
  public function setRecordsRead($recordsRead)
  {
    $this->recordsRead = $recordsRead;
  }
  /**
   * @return string
   */
  public function getRecordsRead()
  {
    return $this->recordsRead;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InputMetrics::class, 'Google_Service_Dataproc_InputMetrics');
