<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DataLabeling;

class GoogleCloudDatalabelingV1beta1SegmentationConfig extends \Google\Model
{
  /**
   * Required. Annotation spec set resource name. format:
   * projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}
   *
   * @var string
   */
  public $annotationSpecSet;
  /**
   * Instruction message showed on labelers UI.
   *
   * @var string
   */
  public $instructionMessage;

  /**
   * Required. Annotation spec set resource name. format:
   * projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}
   *
   * @param string $annotationSpecSet
   */
  public function setAnnotationSpecSet($annotationSpecSet)
  {
    $this->annotationSpecSet = $annotationSpecSet;
  }
  /**
   * @return string
   */
  public function getAnnotationSpecSet()
  {
    return $this->annotationSpecSet;
  }
  /**
   * Instruction message showed on labelers UI.
   *
   * @param string $instructionMessage
   */
  public function setInstructionMessage($instructionMessage)
  {
    $this->instructionMessage = $instructionMessage;
  }
  /**
   * @return string
   */
  public function getInstructionMessage()
  {
    return $this->instructionMessage;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDatalabelingV1beta1SegmentationConfig::class, 'Google_Service_DataLabeling_GoogleCloudDatalabelingV1beta1SegmentationConfig');
