<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class InterconnectsGetMacsecConfigResponse extends \Google\Model
{
  /**
   * end_interface: MixerGetResponseWithEtagBuilder
   *
   * @var string
   */
  public $etag;
  protected $resultType = InterconnectMacsecConfig::class;
  protected $resultDataType = '';

  /**
   * end_interface: MixerGetResponseWithEtagBuilder
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * @param InterconnectMacsecConfig $result
   */
  public function setResult(InterconnectMacsecConfig $result)
  {
    $this->result = $result;
  }
  /**
   * @return InterconnectMacsecConfig
   */
  public function getResult()
  {
    return $this->result;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InterconnectsGetMacsecConfigResponse::class, 'Google_Service_Compute_InterconnectsGetMacsecConfigResponse');
