<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudHealthcare;

class GoogleCloudHealthcareV1ConsentPolicy extends \Google\Collection
{
  protected $collection_key = 'resourceAttributes';
  protected $authorizationRuleType = Expr::class;
  protected $authorizationRuleDataType = '';
  protected $resourceAttributesType = Attribute::class;
  protected $resourceAttributesDataType = 'array';

  /**
   * Required. The request conditions to meet to grant access. In addition to
   * any supported comparison operators, authorization rules may have `IN`
   * operator as well as at most 10 logical operators that are limited to `AND`
   * (`&&`), `OR` (`||`).
   *
   * @param Expr $authorizationRule
   */
  public function setAuthorizationRule(Expr $authorizationRule)
  {
    $this->authorizationRule = $authorizationRule;
  }
  /**
   * @return Expr
   */
  public function getAuthorizationRule()
  {
    return $this->authorizationRule;
  }
  /**
   * The resources that this policy applies to. A resource is a match if it
   * matches all the attributes listed here. If empty, this policy applies to
   * all User data mappings for the given user.
   *
   * @param Attribute[] $resourceAttributes
   */
  public function setResourceAttributes($resourceAttributes)
  {
    $this->resourceAttributes = $resourceAttributes;
  }
  /**
   * @return Attribute[]
   */
  public function getResourceAttributes()
  {
    return $this->resourceAttributes;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudHealthcareV1ConsentPolicy::class, 'Google_Service_CloudHealthcare_GoogleCloudHealthcareV1ConsentPolicy');
