<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudComposer;

class WebServerConfig extends \Google\Model
{
  /**
   * Optional. Machine type on which Airflow web server is running. It has to be
   * one of: composer-n1-webserver-2, composer-n1-webserver-4 or
   * composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be
   * used. Value custom is returned only in response, if Airflow web server
   * parameters were manually changed to a non-standard values.
   *
   * @var string
   */
  public $machineType;

  /**
   * Optional. Machine type on which Airflow web server is running. It has to be
   * one of: composer-n1-webserver-2, composer-n1-webserver-4 or
   * composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be
   * used. Value custom is returned only in response, if Airflow web server
   * parameters were manually changed to a non-standard values.
   *
   * @param string $machineType
   */
  public function setMachineType($machineType)
  {
    $this->machineType = $machineType;
  }
  /**
   * @return string
   */
  public function getMachineType()
  {
    return $this->machineType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(WebServerConfig::class, 'Google_Service_CloudComposer_WebServerConfig');
