<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Classroom;

class CourseAlias extends \Google\Model
{
  /**
   * Alias string. The format of the string indicates the desired alias scoping.
   * * `d:` indicates a domain-scoped alias. Example: `d:math_101` * `p:`
   * indicates a project-scoped alias. Example: `p:abc123` This field has a
   * maximum length of 256 characters.
   *
   * @var string
   */
  public $alias;

  /**
   * Alias string. The format of the string indicates the desired alias scoping.
   * * `d:` indicates a domain-scoped alias. Example: `d:math_101` * `p:`
   * indicates a project-scoped alias. Example: `p:abc123` This field has a
   * maximum length of 256 characters.
   *
   * @param string $alias
   */
  public function setAlias($alias)
  {
    $this->alias = $alias;
  }
  /**
   * @return string
   */
  public function getAlias()
  {
    return $this->alias;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CourseAlias::class, 'Google_Service_Classroom_CourseAlias');
