<?php
require_once 'connect.php';

try {
    $conn = getDatabaseConnection();

    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 5;
    $limit = max(1, min($limit, 20)); 
    
    // get actibe blogs
    $stmt = $conn->prepare("SELECT * FROM blogs WHERE status = 'active' ORDER BY created_at DESC LIMIT :limit");
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $stmt->execute();
    
    $blogs = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Format image URLs
    $base_url = "http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']);
    
    foreach ($blogs as &$blog) {
        if (!empty($blog['cover_image'])) {
            $filename = basename($blog['cover_image']);
            $blog['cover_image'] = $base_url . '/uploads/' . rawurlencode($filename);
        }
    }
    unset($blog); 
    
    echo json_encode($blogs);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
?>