<?php
require_once 'connect.php';

try{
$conn = getDatabaseConnection();


if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['blog_id'])) {
    $blogId = (int)$_GET['blog_id'];
    
    try {
        // Get main comments
        $stmt = $conn->prepare("SELECT * FROM comments WHERE blog_id = ? ORDER BY created_at DESC");
        $stmt->execute([$blogId]);
        $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Get replies for each comment
        foreach ($comments as &$comment) {
            $stmt = $conn->prepare("SELECT * FROM comment_replies WHERE comment_id = ? ORDER BY created_at ASC");
            $stmt->execute([$comment['id']]);
            $comment['replies'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
        
        echo json_encode([
            'success' => true,
            'comments' => $comments ?: [],
            'message' => empty($comments) ? 'No comments yet' : 'Comments loaded'
        ]);
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    }
    exit;
}

// Post reply
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);
    
    // Validate dats
    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        echo json_encode(['success' => false, 'error' => 'Invalid JSON data']);
        exit;
    }
    
    try {
        if (isset($data['is_reply']) && $data['is_reply']) {
            // Validate reply data
            if (empty($data['comment_id']) || empty($data['user_name']) || 
                empty($data['user_email']) || empty($data['content'])) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Missing required fields']);
                exit;
            }
            
            // Add comment
            $stmt = $conn->prepare("
                INSERT INTO comment_replies 
                (comment_id, user_name, user_email, content) 
                VALUES (?, ?, ?, ?)
            ");
            $stmt->execute([
                $data['comment_id'],
                htmlspecialchars($data['user_name']),
                filter_var($data['user_email'], FILTER_SANITIZE_EMAIL),
                htmlspecialchars($data['content'])
            ]);
            
            $replyId = $conn->lastInsertId();
            $stmt = $conn->prepare("SELECT * FROM comment_replies WHERE id = ?");
            $stmt->execute([$replyId]);
            $reply = $stmt->fetch(PDO::FETCH_ASSOC);
            
            echo json_encode(['success' => true, 'reply' => $reply]);
        } else {
            // Validate comment 
            if (empty($data['blog_id']) || empty($data['user_name']) || 
                empty($data['user_email']) || empty($data['content'])) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Missing required fields']);
                exit;
            }
            
            // Add main comment
            $stmt = $conn->prepare("
                INSERT INTO comments 
                (blog_id, user_name, user_email, content) 
                VALUES (?, ?, ?, ?)
            ");
            $stmt->execute([
                $data['blog_id'],
                htmlspecialchars($data['user_name']),
                filter_var($data['user_email'], FILTER_SANITIZE_EMAIL),
                htmlspecialchars($data['content'])
            ]);
            
            $commentId = $conn->lastInsertId();
            $stmt = $conn->prepare("SELECT * FROM comments WHERE id = ?");
            $stmt->execute([$commentId]);
            $comment = $stmt->fetch(PDO::FETCH_ASSOC);
            
            echo json_encode(['success' => true, 'comment' => $comment]);
        }
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    }
    exit;
}


} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request',
        'error' => $e->getMessage(),
    ]);
}
?>