<?php
require_once 'connect.php';

try {
    $conn = getDatabaseConnection();

  

// get data
$title = $_POST['title'] ?? '';
$content = $_POST['content'] ?? '';
$category_id = $_POST['category_id'] ?? '';
$tags = isset($_POST['tags']) ? json_decode($_POST['tags'], true) : []; // Expecting JSON array of tag IDs
$blog_type = $_POST['blog_type'] ?? '';
$status = $_POST['status'] ?? '';

// file upload
$cover_image = '';
if (!empty($_FILES['cover_image']['name'])) {
    $target_dir = "uploads/";
    if (!file_exists($target_dir)) {
        mkdir($target_dir, 0755, true);
    }
    $target_file = $target_dir . basename($_FILES['cover_image']['name']);
    
    if (move_uploaded_file($_FILES['cover_image']['tmp_name'], $target_file)) {
        $cover_image = $target_file;
    }
}

// Validate fields
if (empty($title) || empty($category_id) || empty($blog_type) || empty($status)) {
    http_response_code(400);
    echo json_encode([
        "success" => false,
        "message" => "Required fields are missing",
        "missing_fields" => [
            "title" => empty($title),
            "category_id" => empty($category_id),
            "blog_type" => empty($blog_type),
            "status" => empty($status)
        ]
    ]);
    exit;
}


    $conn->beginTransaction();
    
    // add dats
    $query = "INSERT INTO blogs 
              (title, content, category, blog_type, cover_image, status) 
              VALUES 
              (:title, :content, :category_id, :blog_type, :cover_image, :status)";
    
    $stmt = $conn->prepare($query);
    
    $stmt->bindParam(':title', $title);
    $stmt->bindParam(':content', $content);
    $stmt->bindParam(':category_id', $category_id, PDO::PARAM_INT);
    $stmt->bindParam(':blog_type', $blog_type);
    $stmt->bindParam(':cover_image', $cover_image);
    $stmt->bindParam(':status', $status);
    
    if (!$stmt->execute()) {
        throw new PDOException("Failed to insert blog post");
    }
    
    $blog_id = $conn->lastInsertId();
    
    // add tags
    if (!empty($tags) && is_array($tags)) {
        $tagQuery = "INSERT INTO blog_tags (blog_id, tag_id) VALUES ";
        $tagParams = [];
        $tagValues = [];
        
        foreach ($tags as $index => $tag_id) {
            $tagParams[] = "(:blog_id, :tag_id_" . $index . ")";
            $tagValues[":tag_id_" . $index] = $tag_id;
        }
        
        $tagQuery .= implode(", ", $tagParams);
        $tagStmt = $conn->prepare($tagQuery);
        
        $tagStmt->bindValue(":blog_id", $blog_id, PDO::PARAM_INT);
        foreach ($tagValues as $key => $value) {
            $tagStmt->bindValue($key, $value, PDO::PARAM_INT);
        }
        
        if (!$tagStmt->execute()) {
            throw new PDOException("Failed to insert tags");
        }
    }
    
    $conn->commit();
    
    http_response_code(201);
    echo json_encode([
        "success" => true,
        "message" => "Blog created successfully",
        "blog_id" => $blog_id
    ]);
    
} catch(PDOException $e) {
    $conn->rollBack();
    http_response_code(500);
    echo json_encode([
        "success" => false, 
        "message" => "Database error: " . $e->getMessage(),
        "error_details" => $e->getTraceAsString()
    ]);
}
?>